/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph;

import frc.emul.api.ILogger;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.api.ui.IDisplay;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameHacks;
import frc.emul.periph.IAnalogPeer;
import frc.emul.periph.lightpen.Lightpen;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.ui.GfxItem;
import frc.emul.via6522.I6522ExternalLines;

public class Analog
implements IAnalogPeer,
IPersistentObject {
    public float ramp_delay1 = 0.0f;
    public float ramp_delay2 = 0.0f;
    int rampDelay = -1;
    int lastDX;
    int lastDY;
    boolean wasLowRAMP;
    private static final boolean REMOVE_POINTS = true;
    private int lastPointX;
    private int lastPointY;
    private int lastLineEndX;
    private int lastLineEndY;
    private int lastLineStartX;
    private int lastLineStartY;
    public static Analog INSTANCE;
    private static final int W2 = 16500;
    private static final int H2 = 20500;
    private static final float W2f = 16500.0f;
    private static final float H2f = 20500.0f;
    private final I6522ExternalLines lines;
    private final Configuration conf;
    private IDisplay display;
    private Lightpen lightpen;
    int rX;
    int rY;
    int rZ;
    int rREF;
    private int xPos;
    private int yPos;
    private int lineX0;
    private int lineY0;
    private int lineX1;
    private int lineY1;
    private int lineVX;
    private int lineVY;
    private int lineZ;
    private boolean drawing;

    public Analog(Configuration configuration, ILogger iLogger, I6522ExternalLines i6522ExternalLines) {
        this.lines = i6522ExternalLines;
        this.conf = configuration;
        INSTANCE = this;
    }

    void setDisplay(IDisplay iDisplay) {
        if (this.display != null) {
            this.display.setAnalogPeer(null);
        }
        this.display = iDisplay;
        this.display.setAnalogPeer(this);
    }

    void initialise() {
        CfgItemGame cfgItemGame;
        this.prepareNewFrame();
        CfgItemGame cfgItemGame2 = cfgItemGame = this.conf == null ? null : this.conf.getSelectedGame();
        if (cfgItemGame != null && cfgItemGame.hacks.isEffective()) {
            CfgItemGameHacks cfgItemGameHacks = cfgItemGame.hacks;
            this.ramp_delay1 = cfgItemGameHacks.getRampDelay1();
            this.ramp_delay2 = cfgItemGameHacks.getRampDelay2();
        } else {
            this.ramp_delay1 = 0.0f;
            this.ramp_delay2 = 0.0f;
        }
    }

    void reset() {
        this.prepareNewFrame();
        this.xPos = 0;
        this.yPos = 0;
    }

    void setLightpen(Lightpen lightpen) {
        this.lightpen = lightpen;
    }

    void frameCompleted() {
        this.prepareNewFrame();
    }

    public void flushCurrentLine() {
        if (this.drawing && this.lineZ > 0 && (this.lineX0 != this.lineX1 || this.lineY0 != this.lineY1)) {
            this.display.addLine((float)this.lineX0 / 16500.0f, (float)this.lineY0 / 20500.0f, (float)this.lineX1 / 16500.0f, (float)this.lineY1 / 20500.0f, this.lineZ);
        }
    }

    public void getBeamPosition(GfxItem gfxItem) {
        gfxItem.x0 = (float)this.xPos / 16500.0f;
        gfxItem.y0 = (float)this.yPos / 20500.0f;
    }

    void step(int n) {
        int n2;
        int n3;
        boolean bl = (n & 0x80) == 0;
        boolean bl2 = bl ^ this.wasLowRAMP;
        if (bl2 && this.ramp_delay2 != 0.0f) {
            if (this.rampDelay < 0) {
                this.rampDelay = 0.0f == this.ramp_delay1 ? 5 : (int)(this.ramp_delay1 * 0.25f);
            } else {
                --this.rampDelay;
                if (this.rampDelay < 0) {
                    this.wasLowRAMP = bl;
                } else {
                    bl = this.wasLowRAMP;
                }
            }
        } else {
            this.rampDelay = -1;
        }
        boolean bl3 = this.lines.read_CB2();
        if (this.lines.read_CA2()) {
            if (!bl) {
                n3 = 0;
                n2 = 0;
            } else {
                n3 = this.rX - this.rREF;
                n2 = this.rY - this.rREF;
            }
        } else {
            n3 = -this.xPos;
            n2 = -this.yPos;
        }
        if (this.drawing && (!bl3 || n3 != this.lineVX || n2 != this.lineVY || this.rZ != this.lineZ || this.xPos < -16500 || this.yPos < -20500 || this.xPos > 16500 || this.yPos > 20500)) {
            this.validateLine();
            this.drawing = false;
        }
        if (!this.drawing && bl3 && this.xPos >= -16500 && this.yPos >= -20500 && this.xPos <= 16500 && this.yPos <= 20500) {
            this.lineX0 = this.xPos;
            this.lineY0 = this.yPos;
            this.lineVX = n3;
            this.lineVY = n2;
            this.lineZ = this.rZ;
            this.drawing = true;
        }
        this.xPos += n3;
        this.yPos += n2;
        if (this.drawing) {
            if (this.lightpen != null) {
                this.lightpen.checkHit((float)this.xPos / 16500.0f, (float)this.yPos / 20500.0f);
            }
            this.lineX1 = this.xPos;
            this.lineY1 = this.yPos;
        }
    }

    private void validateLine() {
        if (this.lineZ > 0) {
            if (this.lineX0 == this.lineX1 && this.lineY0 == this.lineY1) {
                if (this.lineX0 == this.lastLineEndX && this.lineY0 == this.lastLineEndY) {
                    return;
                }
                if (this.lineX0 == this.lastLineStartX && this.lineY0 == this.lastLineStartY) {
                    return;
                }
                if (this.lineX0 == this.lastPointX && this.lineY0 == this.lastPointY) {
                    return;
                }
                this.lastPointX = this.lineX0;
                this.lastPointY = this.lineY0;
                this.display.addPoint((float)this.lineX0 / 16500.0f, (float)this.lineY0 / 20500.0f, this.lineZ);
            } else {
                this.display.addLine((float)this.lineX0 / 16500.0f, (float)this.lineY0 / 20500.0f, (float)this.lineX1 / 16500.0f, (float)this.lineY1 / 20500.0f, this.lineZ);
                if (this.lineX0 == this.lastPointX && this.lineY0 == this.lastPointY) {
                    this.display.removeLastPoint();
                } else if (this.lineX1 == this.lastPointX && this.lineY1 == this.lastPointY) {
                    this.display.removeLastPoint();
                }
                this.lastLineStartX = this.lineX0;
                this.lastLineStartY = this.lineY0;
                this.lastLineEndX = this.lineX1;
                this.lastLineEndY = this.lineY1;
            }
        }
    }

    private final void prepareNewFrame() {
        this.lastPointX = Integer.MAX_VALUE;
        this.lastPointY = Integer.MAX_VALUE;
        this.lastLineEndX = Integer.MAX_VALUE;
        this.lastLineEndY = Integer.MAX_VALUE;
        this.lastLineStartX = Integer.MAX_VALUE;
        this.lastLineStartY = Integer.MAX_VALUE;
    }

    public IPersistentSection getSection() {
        return null;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.openSection(PersistentSection.ANALOG);
        iPersistenceWriter.write(this.ramp_delay1);
        iPersistenceWriter.write(this.ramp_delay2);
        iPersistenceWriter.write(this.rampDelay);
        iPersistenceWriter.write(this.lastDX);
        iPersistenceWriter.write(this.lastDY);
        iPersistenceWriter.write(this.wasLowRAMP);
        iPersistenceWriter.write(this.lastPointX);
        iPersistenceWriter.write(this.lastPointY);
        iPersistenceWriter.write(this.lastLineEndX);
        iPersistenceWriter.write(this.lastLineEndY);
        iPersistenceWriter.write(this.lastLineStartX);
        iPersistenceWriter.write(this.lastLineStartY);
        iPersistenceWriter.write(this.rX);
        iPersistenceWriter.write(this.rY);
        iPersistenceWriter.write(this.rZ);
        iPersistenceWriter.write(this.rREF);
        iPersistenceWriter.write(this.xPos);
        iPersistenceWriter.write(this.yPos);
        iPersistenceWriter.write(this.lineX0);
        iPersistenceWriter.write(this.lineY0);
        iPersistenceWriter.write(this.lineX1);
        iPersistenceWriter.write(this.lineY1);
        iPersistenceWriter.write(this.lineVX);
        iPersistenceWriter.write(this.lineVY);
        iPersistenceWriter.write(this.lineZ);
        iPersistenceWriter.write(this.drawing);
        iPersistenceWriter.closeSection();
        iPersistenceWriter.write(this.display);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.openSection(PersistentSection.ANALOG);
        this.ramp_delay1 = iPersistenceReader.readFloat();
        this.ramp_delay2 = iPersistenceReader.readFloat();
        this.rampDelay = iPersistenceReader.readInt();
        this.lastDX = iPersistenceReader.readInt();
        this.lastDY = iPersistenceReader.readInt();
        this.wasLowRAMP = iPersistenceReader.readBool();
        this.lastPointX = iPersistenceReader.readInt();
        this.lastPointY = iPersistenceReader.readInt();
        this.lastLineEndX = iPersistenceReader.readInt();
        this.lastLineEndY = iPersistenceReader.readInt();
        this.lastLineStartX = iPersistenceReader.readInt();
        this.lastLineStartY = iPersistenceReader.readInt();
        this.rX = iPersistenceReader.readInt();
        this.rY = iPersistenceReader.readInt();
        this.rZ = iPersistenceReader.readInt();
        this.rREF = iPersistenceReader.readInt();
        this.xPos = iPersistenceReader.readInt();
        this.yPos = iPersistenceReader.readInt();
        this.lineX0 = iPersistenceReader.readInt();
        this.lineY0 = iPersistenceReader.readInt();
        this.lineX1 = iPersistenceReader.readInt();
        this.lineY1 = iPersistenceReader.readInt();
        this.lineVX = iPersistenceReader.readInt();
        this.lineVY = iPersistenceReader.readInt();
        this.lineZ = iPersistenceReader.readInt();
        this.drawing = iPersistenceReader.readBool();
        iPersistenceReader.closeSection();
        iPersistenceReader.read(this.display);
    }
}

